/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IStamina;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncStaminaMessage {
    private int stamina = 0;
    private boolean exhausted = false;
    private int clientDemandedMaxValue = 0;
    private UUID playerID = null;

    public void encode(FriendlyByteBuf packet) {
        packet.writeInt(this.stamina);
        packet.writeBoolean(this.exhausted);
        packet.writeInt(this.clientDemandedMaxValue);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static SyncStaminaMessage decode(FriendlyByteBuf packet) {
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = packet.readInt();
        message.exhausted = packet.readBoolean();
        message.clientDemandedMaxValue = packet.readInt();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            IStamina stamina = IStamina.get((Player)player);
            if (stamina == null) {
                return;
            }
            stamina.set(this.stamina);
            stamina.setExhaustion(this.exhausted);
            stamina.setMaxStamina(this.clientDemandedMaxValue);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            IStamina stamina;
            ServerPlayer player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    return;
                }
                player = world.m_46003_(this.playerID);
                if (player == null || player.m_7578_()) {
                    return;
                }
            } else {
                player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (player == null) {
                    return;
                }
            }
            if ((stamina = IStamina.get((Player)player)) == null) {
                return;
            }
            stamina.set(this.stamina);
            stamina.setExhaustion(this.exhausted);
            stamina.setMaxStamina(this.clientDemandedMaxValue);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(Player player) {
        IStamina stamina = IStamina.get(player);
        if (stamina == null || !player.m_7578_()) {
            return;
        }
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = stamina.get();
        message.exhausted = stamina.isExhausted();
        message.playerID = player.m_20148_();
        message.clientDemandedMaxValue = (Integer)ParCoolConfig.CONFIG_CLIENT.staminaMax.get();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

